/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamdraco.unnamedanimalmod.common.entity.BananaSlugEntity;
import teamdraco.unnamedanimalmod.init.UAMBlocks;

public class SaltPowderBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape BARRIER_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)-4.0, (double)0.0, (double)1.0, (double)5.0, (double)1.0);
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SIDE_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SIDE_TO_ASCENDING_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_TO_SHAPE.get(Direction.NORTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_TO_SHAPE.get(Direction.SOUTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_TO_SHAPE.get(Direction.EAST), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_TO_SHAPE.get(Direction.WEST), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> stateToShapeMap = Maps.newHashMap();
    private final BlockState sideBaseState;

    public SaltPowderBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE));
        this.sideBaseState = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(EAST, (Comparable)RedstoneSide.SIDE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            this.stateToShapeMap.put(blockstate, this.getShapeForState(blockstate));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor() {
        return MathHelper.func_180181_b((int)224, (int)190, (int)183);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        LivingEntity entity;
        if (context.getEntity() instanceof LivingEntity && (entity = (LivingEntity)context.getEntity()).func_70662_br()) {
            return BARRIER_SHAPE;
        }
        return super.func_220071_b(state, world, pos, context);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if ((entityIn instanceof BananaSlugEntity || livingEntity.func_70668_bt() == CreatureAttribute.field_223223_b_) && entityIn.field_70170_p.func_82737_E() % 20L == 0L) {
                entityIn.func_70097_a(DamageSource.field_205132_u, 1.0f);
            }
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    private VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelshape = BASE_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_SHAPE.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SIDE_TO_ASCENDING_SHAPE.get(direction));
        }
        return voxelshape;
    }

    private static boolean areAllSidesInvalid(BlockState state) {
        return !((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    private static boolean areAllSidesValid(BlockState state) {
        return ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    private BlockState recalculateFacingState(IBlockReader reader, BlockState state, BlockPos pos) {
        boolean flag = !reader.func_180495_p(pos.func_177984_a()).func_215686_e(reader, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.recalculateSide(reader, pos, direction, flag);
            state = (BlockState)state.func_206870_a((Property)FACING_PROPERTY_MAP.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        return this.recalculateSide(worldIn, pos, face, !worldIn.func_180495_p(pos.func_177984_a()).func_215686_e(worldIn, pos));
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$mutable.func_239622_a_((Vector3i)pos, direction)).func_203425_a((Block)this)) continue;
            blockpos$mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = blockpos$mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                SaltPowderBlock.func_241468_a_((BlockState)blockstate, (BlockState)blockstate1, (IWorld)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
            }
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = blockpos$mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            SaltPowderBlock.func_241468_a_((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)recursionLeft);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return this.getUpdatedState((IBlockReader)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.getSide((IBlockReader)worldIn, currentPos, facing);
        return redstoneside.func_235921_b_() == ((RedstoneSide)stateIn.func_177229_b((Property)FACING_PROPERTY_MAP.get(facing))).func_235921_b_() && !SaltPowderBlock.areAllSidesValid(stateIn) ? (BlockState)stateIn.func_206870_a((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside) : this.getUpdatedState((IBlockReader)worldIn, (BlockState)this.sideBaseState.func_206870_a((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside), currentPos);
    }

    private RedstoneSide recalculateSide(IBlockReader reader, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        boolean flag;
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = reader.func_180495_p(blockpos);
        if (nonNormalCubeAbove && (flag = this.canPlaceOnTopOf(reader, blockpos, blockstate)) && SaltPowderBlock.canConnectTo(reader.func_180495_p(blockpos.func_177984_a()), reader, blockpos.func_177984_a(), null)) {
            if (blockstate.func_224755_d(reader, blockpos, direction.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !SaltPowderBlock.canConnectTo(blockstate, reader, blockpos, direction) && (blockstate.func_215686_e(reader, blockpos) || !SaltPowderBlock.canConnectTo(reader.func_180495_p(blockpos.func_177977_b()), reader, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    private boolean canPlaceOnTopOf(IBlockReader reader, BlockPos pos, BlockState state) {
        return state.func_224755_d(reader, pos, Direction.UP);
    }

    private BlockState getUpdatedState(IBlockReader reader, BlockState state, BlockPos pos) {
        boolean flag6;
        boolean flag = SaltPowderBlock.areAllSidesInvalid(state);
        state = this.recalculateFacingState(reader, this.func_176223_P(), pos);
        if (flag && SaltPowderBlock.areAllSidesInvalid(state)) {
            return state;
        }
        boolean flag1 = ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_();
        boolean flag2 = ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_();
        boolean flag3 = ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_();
        boolean flag4 = ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            state = (BlockState)state.func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            state = (BlockState)state.func_206870_a(EAST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            state = (BlockState)state.func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            state = (BlockState)state.func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE);
        }
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getUpdatedState((IBlockReader)context.func_195991_k(), this.sideBaseState, context.func_195995_a());
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c()) && !worldIn.field_72995_K) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            this.updateNeighboursStateChange(worldIn, pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (!p_225533_4_.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (SaltPowderBlock.isCross(p_225533_1_) || SaltPowderBlock.isDot(p_225533_1_)) {
            BlockState blockstate = SaltPowderBlock.isCross(p_225533_1_) ? this.func_176223_P() : this.sideBaseState;
            if ((blockstate = this.getConnectionState((IBlockReader)p_225533_2_, blockstate, p_225533_3_)) != p_225533_1_) {
                p_225533_2_.func_180501_a(p_225533_3_, blockstate, 3);
                this.updatesOnShapeChange(p_225533_2_, p_225533_3_, p_225533_1_, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void updatesOnShapeChange(World p_235548_1_, BlockPos p_235548_2_, BlockState p_235548_3_, BlockState p_235548_4_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_235548_2_.func_177972_a(direction);
            if (((RedstoneSide)p_235548_3_.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction))).func_235921_b_() == ((RedstoneSide)p_235548_4_.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction))).func_235921_b_() || !p_235548_1_.func_180495_p(blockpos).func_215686_e((IBlockReader)p_235548_1_, blockpos)) continue;
            p_235548_1_.func_175695_a(blockpos, p_235548_4_.func_177230_c(), direction.func_176734_d());
        }
    }

    private BlockState getMissingConnections(IBlockReader p_235551_1_, BlockState p_235551_2_, BlockPos p_235551_3_) {
        boolean flag = !p_235551_1_.func_180495_p(p_235551_3_.func_177984_a()).func_215686_e(p_235551_1_, p_235551_3_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)p_235551_2_.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.recalculateSide(p_235551_1_, p_235551_3_, direction, flag);
            p_235551_2_ = (BlockState)p_235551_2_.func_206870_a((Property)FACING_PROPERTY_MAP.get(direction), (Comparable)redstoneside);
        }
        return p_235551_2_;
    }

    private BlockState getConnectionState(IBlockReader p_235544_1_, BlockState p_235544_2_, BlockPos p_235544_3_) {
        boolean flag6;
        boolean flag = SaltPowderBlock.isDot(p_235544_2_);
        p_235544_2_ = this.getMissingConnections(p_235544_1_, this.func_176223_P(), p_235544_3_);
        if (flag && SaltPowderBlock.isDot(p_235544_2_)) {
            return p_235544_2_;
        }
        boolean flag1 = ((RedstoneSide)p_235544_2_.func_177229_b(NORTH)).func_235921_b_();
        boolean flag2 = ((RedstoneSide)p_235544_2_.func_177229_b(SOUTH)).func_235921_b_();
        boolean flag3 = ((RedstoneSide)p_235544_2_.func_177229_b(EAST)).func_235921_b_();
        boolean flag4 = ((RedstoneSide)p_235544_2_.func_177229_b(WEST)).func_235921_b_();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(EAST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            p_235544_2_ = (BlockState)p_235544_2_.func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE);
        }
        return p_235544_2_;
    }

    private static boolean isCross(BlockState p_235555_0_) {
        return ((RedstoneSide)p_235555_0_.func_177229_b(NORTH)).func_235921_b_() && ((RedstoneSide)p_235555_0_.func_177229_b(SOUTH)).func_235921_b_() && ((RedstoneSide)p_235555_0_.func_177229_b(EAST)).func_235921_b_() && ((RedstoneSide)p_235555_0_.func_177229_b(WEST)).func_235921_b_();
    }

    private static boolean isDot(BlockState p_235556_0_) {
        return !((RedstoneSide)p_235556_0_.func_177229_b(NORTH)).func_235921_b_() && !((RedstoneSide)p_235556_0_.func_177229_b(SOUTH)).func_235921_b_() && !((RedstoneSide)p_235556_0_.func_177229_b(EAST)).func_235921_b_() && !((RedstoneSide)p_235556_0_.func_177229_b(WEST)).func_235921_b_();
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return entity instanceof LivingEntity && ((LivingEntity)entity).func_70662_br();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return this.canPlaceOnTopOf((IBlockReader)worldIn, blockpos, blockstate);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateNeighboursStateChange(worldIn, pos);
            }
        }
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_203425_a((Block)this)) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    private void updateNeighboursStateChange(World world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.notifyWireNeighborsOfStateChange(world, pos.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction1);
            if (world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) {
                this.notifyWireNeighborsOfStateChange(world, blockpos.func_177984_a());
                continue;
            }
            this.notifyWireNeighborsOfStateChange(world, blockpos.func_177977_b());
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && !state.func_196955_c((IWorldReader)worldIn, pos)) {
            SaltPowderBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        return blockState.func_203425_a((Block)UAMBlocks.SALT.get());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

